/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.llc.eui;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.LongNumericInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class LlcSapsPanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "SAPs";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel LlcSaps_model;
    protected selectionListSection selectionListPropertySection;
    protected llcSapDetailSection llcSapDetailPropertySection;
    protected ModelInfo LlcSapsInfo;
    protected ModelInfo PanelInfo;
    protected ModelInfo IndexInfo;
    protected int LlcSapsIndex;
    protected LlcSaps LlcSapsData;
    protected TableColumns LlcSapsColumns;
    protected TableStatus LlcSapsStatus;
    protected static TableColumn[] LlcSapsCols = new TableColumn[]{new TableColumn("Index.IfIndex", "Interface", 3, true), new TableColumn("Index.LlcSapNumber", "SAP Number", 3, true), new TableColumn("Panel.IfDescr", "Description", 5, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.llc.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.llc.eui.LlcSapsPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel LlcSaps");
        }
    }

    public static String getTitle() {
        LlcSapsPanel.loadStatics();
        if (myResources != null) {
            title = LlcSapsPanel.getNLSString("LlcSapsPanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            LlcSapsPanel.loadStatics();
        }
        return enumStrings;
    }

    public LlcSapsPanel() {
        LlcSapsPanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return LlcSapsPanel.getTitle();
    }

    protected void getModels() {
        this.LlcSaps_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addselectionListSection();
        this.addllcSapDetailSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addselectionListSection() {
        this.selectionListPropertySection = new selectionListSection();
        this.selectionListPropertySection.layoutSection();
        this.addSection(LlcSapsPanel.getNLSString("selectionListSectionTitle"), this.selectionListPropertySection);
    }

    protected void addllcSapDetailSection() {
        this.llcSapDetailPropertySection = new llcSapDetailSection();
        this.llcSapDetailPropertySection.layoutSection();
        this.addSection(LlcSapsPanel.getNLSString("llcSapDetailSectionTitle"), this.llcSapDetailPropertySection);
    }

    protected void panelRowChange() {
        if (this.selectionListPropertySection != null) {
            this.selectionListPropertySection.rowChange();
        }
        if (this.llcSapDetailPropertySection != null) {
            this.llcSapDetailPropertySection.rowChange();
        }
    }

    public void filterPanelInfos(Vector vector) {
    }

    public int getInitialLlcSapsRow() {
        return 0;
    }

    public ModelInfo initialLlcSapsRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(LlcSapsPanel.getNLSString("startResetMsg"));
        this.LlcSapsData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(LlcSapsPanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(LlcSapsPanel.getNLSString("endResetMsg")) + " " + LlcSapsPanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.IndexInfo = new ModelInfo();
        this.PanelInfo = new ModelInfo();
        this.PanelInfo.add("Index.IfIndex", (Serializable)this.LlcSapsData.getValueAt("Index.IfIndex", this.LlcSapsIndex));
        this.PanelInfo.add("Index.LlcSapNumber", (Serializable)this.LlcSapsData.getValueAt("Index.LlcSapNumber", this.LlcSapsIndex));
        this.errorsFound = false;
        this.displayMsg(LlcSapsPanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.LlcSapsInfo = (ModelInfo)this.LlcSapsData.elementAt(this.LlcSapsIndex);
            this.LlcSapsInfo = this.LlcSapsData.setRow();
            this.LlcSapsData.setElementAt(this.LlcSapsInfo, this.LlcSapsIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(LlcSapsPanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(LlcSapsPanel.getNLSString("endApplyMsg")) + " " + LlcSapsPanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(LlcSapsPanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.LlcSapsData = new LlcSaps();
        this.LlcSapsIndex = 0;
        this.LlcSapsColumns = new TableColumns(LlcSapsCols);
        if (this.LlcSaps_model instanceof RemoteModelWithStatus) {
            try {
                this.LlcSapsStatus = (TableStatus)this.LlcSaps_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class selectionListSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component LlcSapsField;
        Label LlcSapsFieldLabel;
        boolean LlcSapsFieldWritable = false;

        public selectionListSection() {
            LlcSapsPanel.this = LlcSapsPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createLlcSapsField() {
            EuiGrid euiGrid = new EuiGrid(LlcSapsPanel.this.LlcSapsData, LlcSapsPanel.this.LlcSapsColumns, false);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(LlcSapsPanel.this.initialLlcSapsRow());
            this.addTable(LlcSapsPanel.getNLSString("LlcSapsLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.LlcSapsField = this.createLlcSapsField();
        }

        public void apply() {
            if (!this.validateSection()) {
                LlcSapsPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("accessDataMsg"));
            LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.LlcSapsField).refresh();
            LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("endTableGetMsg"));
            LlcSapsPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.LlcSapsField) {
                        LlcSapsPanel.this.LlcSapsIndex = euiGridEvent.getRow();
                    }
                    LlcSapsPanel.this.LlcSapsIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.LlcSapsField).deselectAllRows();
                    LlcSapsPanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.LlcSapsField) {
                        LlcSapsPanel.this.LlcSapsIndex = 0;
                    }
                    LlcSapsPanel.this.selectionListPropertySection.reset();
                    LlcSapsPanel.this.llcSapDetailPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class llcSapDetailSection
    extends PropertySection {
        ModelInfo chunk;
        Component ifIndexField;
        Component ifDescrField;
        Component llcSapNumberField;
        Component llcSapAdminMaxIPDUOctetsSendField;
        Component llcSapAdminMaxUnackedIPDUsSendField;
        Component llcSapAdminMaxUnackedIPDUsRcvField;
        Component llcSapAdminMaxRetransmitsField;
        Component llcSapAdminAckTimerField;
        Component llcSapAdminInactTimerField;
        Component llcSapAdminDelayAckCountField;
        Component llcSapAdminDelayAckTimerField;
        Label ifIndexFieldLabel;
        Label ifDescrFieldLabel;
        Label llcSapNumberFieldLabel;
        Label llcSapAdminMaxIPDUOctetsSendFieldLabel;
        Label llcSapAdminMaxUnackedIPDUsSendFieldLabel;
        Label llcSapAdminMaxUnackedIPDUsRcvFieldLabel;
        Label llcSapAdminMaxRetransmitsFieldLabel;
        Label llcSapAdminAckTimerFieldLabel;
        Label llcSapAdminInactTimerFieldLabel;
        Label llcSapAdminDelayAckCountFieldLabel;
        Label llcSapAdminDelayAckTimerFieldLabel;
        boolean ifIndexFieldWritable = false;
        boolean ifDescrFieldWritable = false;
        boolean llcSapNumberFieldWritable = false;
        boolean llcSapAdminMaxIPDUOctetsSendFieldWritable = false;
        boolean llcSapAdminMaxUnackedIPDUsSendFieldWritable = false;
        boolean llcSapAdminMaxUnackedIPDUsRcvFieldWritable = false;
        boolean llcSapAdminMaxRetransmitsFieldWritable = false;
        boolean llcSapAdminAckTimerFieldWritable = false;
        boolean llcSapAdminInactTimerFieldWritable = false;
        boolean llcSapAdminDelayAckCountFieldWritable = false;
        boolean llcSapAdminDelayAckTimerFieldWritable = false;

        public llcSapDetailSection() {
            LlcSapsPanel.this = LlcSapsPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createifIndexField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Index.IfIndex.access", "unknown");
            this.ifIndexFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.ifIndexFieldLabel = new Label(LlcSapsPanel.getNLSString("ifIndexLabel"), 2);
            if (this.ifIndexFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.ifIndexFieldLabel, (Component)numericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.ifIndexFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getifIndexField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifIndexField);
            this.validateifIndexField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setifIndexField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.ifIndexField);
                jDMInput.setValue(object);
                this.validateifIndexField();
            }
        }

        protected boolean validateifIndexField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifIndexField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.ifIndexFieldLabel.setForeground(Color.yellow);
            } else {
                this.ifIndexFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createifDescrField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.IfDescr.access", "read-only");
            String string2 = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.IfDescr.length", "255");
            this.ifDescrFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.ifDescrFieldLabel = new Label(LlcSapsPanel.getNLSString("ifDescrLabel"), 2);
            if (this.ifDescrFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.ifDescrFieldLabel, (Component)stringInput);
                LlcSapsPanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.ifDescrFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getifDescrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifDescrField);
            this.validateifDescrField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setifDescrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.ifDescrField);
                jDMInput.setValue(object);
                this.validateifDescrField();
            }
        }

        protected boolean validateifDescrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifDescrField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.ifDescrFieldLabel.setForeground(Color.yellow);
            } else {
                this.ifDescrFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createllcSapNumberField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Index.LlcSapNumber.access", "unknown");
            this.llcSapNumberFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.llcSapNumberFieldLabel = new Label(LlcSapsPanel.getNLSString("llcSapNumberLabel"), 2);
            if (this.llcSapNumberFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 255);
                this.addRow(this.llcSapNumberFieldLabel, (Component)numericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.llcSapNumberFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getllcSapNumberField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapNumberField);
            this.validatellcSapNumberField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setllcSapNumberField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.llcSapNumberField);
                jDMInput.setValue(object);
                this.validatellcSapNumberField();
            }
        }

        protected boolean validatellcSapNumberField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapNumberField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.llcSapNumberFieldLabel.setForeground(Color.yellow);
            } else {
                this.llcSapNumberFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createllcSapAdminMaxIPDUOctetsSendField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminMaxIPDUOctetsSend.access", "read-write");
            this.llcSapAdminMaxIPDUOctetsSendFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.llcSapAdminMaxIPDUOctetsSendFieldLabel = new Label(LlcSapsPanel.getNLSString("llcSapAdminMaxIPDUOctetsSendLabel"), 2);
            if (this.llcSapAdminMaxIPDUOctetsSendFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.llcSapAdminMaxIPDUOctetsSendFieldLabel, (Component)numericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.llcSapAdminMaxIPDUOctetsSendFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getllcSapAdminMaxIPDUOctetsSendField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxIPDUOctetsSendField);
            this.validatellcSapAdminMaxIPDUOctetsSendField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setllcSapAdminMaxIPDUOctetsSendField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxIPDUOctetsSendField);
                jDMInput.setValue(object);
                this.validatellcSapAdminMaxIPDUOctetsSendField();
            }
        }

        protected boolean validatellcSapAdminMaxIPDUOctetsSendField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxIPDUOctetsSendField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.llcSapAdminMaxIPDUOctetsSendFieldLabel.setForeground(Color.yellow);
            } else {
                this.llcSapAdminMaxIPDUOctetsSendFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createllcSapAdminMaxUnackedIPDUsSendField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminMaxUnackedIPDUsSend.access", "read-write");
            this.llcSapAdminMaxUnackedIPDUsSendFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.llcSapAdminMaxUnackedIPDUsSendFieldLabel = new Label(LlcSapsPanel.getNLSString("llcSapAdminMaxUnackedIPDUsSendLabel"), 2);
            if (this.llcSapAdminMaxUnackedIPDUsSendFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 127);
                this.addRow(this.llcSapAdminMaxUnackedIPDUsSendFieldLabel, (Component)numericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.llcSapAdminMaxUnackedIPDUsSendFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getllcSapAdminMaxUnackedIPDUsSendField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsSendField);
            this.validatellcSapAdminMaxUnackedIPDUsSendField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setllcSapAdminMaxUnackedIPDUsSendField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsSendField);
                jDMInput.setValue(object);
                this.validatellcSapAdminMaxUnackedIPDUsSendField();
            }
        }

        protected boolean validatellcSapAdminMaxUnackedIPDUsSendField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsSendField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.llcSapAdminMaxUnackedIPDUsSendFieldLabel.setForeground(Color.yellow);
            } else {
                this.llcSapAdminMaxUnackedIPDUsSendFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createllcSapAdminMaxUnackedIPDUsRcvField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminMaxUnackedIPDUsRcv.access", "read-write");
            this.llcSapAdminMaxUnackedIPDUsRcvFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.llcSapAdminMaxUnackedIPDUsRcvFieldLabel = new Label(LlcSapsPanel.getNLSString("llcSapAdminMaxUnackedIPDUsRcvLabel"), 2);
            if (this.llcSapAdminMaxUnackedIPDUsRcvFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 127);
                this.addRow(this.llcSapAdminMaxUnackedIPDUsRcvFieldLabel, (Component)numericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.llcSapAdminMaxUnackedIPDUsRcvFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getllcSapAdminMaxUnackedIPDUsRcvField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsRcvField);
            this.validatellcSapAdminMaxUnackedIPDUsRcvField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setllcSapAdminMaxUnackedIPDUsRcvField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsRcvField);
                jDMInput.setValue(object);
                this.validatellcSapAdminMaxUnackedIPDUsRcvField();
            }
        }

        protected boolean validatellcSapAdminMaxUnackedIPDUsRcvField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsRcvField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.llcSapAdminMaxUnackedIPDUsRcvFieldLabel.setForeground(Color.yellow);
            } else {
                this.llcSapAdminMaxUnackedIPDUsRcvFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createllcSapAdminMaxRetransmitsField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminMaxRetransmits.access", "read-write");
            this.llcSapAdminMaxRetransmitsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.llcSapAdminMaxRetransmitsFieldLabel = new Label(LlcSapsPanel.getNLSString("llcSapAdminMaxRetransmitsLabel"), 2);
            if (this.llcSapAdminMaxRetransmitsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.llcSapAdminMaxRetransmitsFieldLabel, (Component)numericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.llcSapAdminMaxRetransmitsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getllcSapAdminMaxRetransmitsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxRetransmitsField);
            this.validatellcSapAdminMaxRetransmitsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setllcSapAdminMaxRetransmitsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxRetransmitsField);
                jDMInput.setValue(object);
                this.validatellcSapAdminMaxRetransmitsField();
            }
        }

        protected boolean validatellcSapAdminMaxRetransmitsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminMaxRetransmitsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.llcSapAdminMaxRetransmitsFieldLabel.setForeground(Color.yellow);
            } else {
                this.llcSapAdminMaxRetransmitsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createllcSapAdminAckTimerField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminAckTimer.access", "read-write");
            this.llcSapAdminAckTimerFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.llcSapAdminAckTimerFieldLabel = new Label(LlcSapsPanel.getNLSString("llcSapAdminAckTimerLabel"), 2);
            if (this.llcSapAdminAckTimerFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.llcSapAdminAckTimerFieldLabel, (Component)longNumericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.llcSapAdminAckTimerFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getllcSapAdminAckTimerField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminAckTimerField);
            this.validatellcSapAdminAckTimerField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setllcSapAdminAckTimerField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminAckTimerField);
                jDMInput.setValue(object);
                this.validatellcSapAdminAckTimerField();
            }
        }

        protected boolean validatellcSapAdminAckTimerField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminAckTimerField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.llcSapAdminAckTimerFieldLabel.setForeground(Color.yellow);
            } else {
                this.llcSapAdminAckTimerFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createllcSapAdminInactTimerField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminInactTimer.access", "read-write");
            this.llcSapAdminInactTimerFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.llcSapAdminInactTimerFieldLabel = new Label(LlcSapsPanel.getNLSString("llcSapAdminInactTimerLabel"), 2);
            if (this.llcSapAdminInactTimerFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.llcSapAdminInactTimerFieldLabel, (Component)longNumericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.llcSapAdminInactTimerFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getllcSapAdminInactTimerField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminInactTimerField);
            this.validatellcSapAdminInactTimerField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setllcSapAdminInactTimerField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminInactTimerField);
                jDMInput.setValue(object);
                this.validatellcSapAdminInactTimerField();
            }
        }

        protected boolean validatellcSapAdminInactTimerField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminInactTimerField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.llcSapAdminInactTimerFieldLabel.setForeground(Color.yellow);
            } else {
                this.llcSapAdminInactTimerFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createllcSapAdminDelayAckCountField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminDelayAckCount.access", "read-write");
            this.llcSapAdminDelayAckCountFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.llcSapAdminDelayAckCountFieldLabel = new Label(LlcSapsPanel.getNLSString("llcSapAdminDelayAckCountLabel"), 2);
            if (this.llcSapAdminDelayAckCountFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.llcSapAdminDelayAckCountFieldLabel, (Component)numericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.llcSapAdminDelayAckCountFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getllcSapAdminDelayAckCountField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminDelayAckCountField);
            this.validatellcSapAdminDelayAckCountField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setllcSapAdminDelayAckCountField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminDelayAckCountField);
                jDMInput.setValue(object);
                this.validatellcSapAdminDelayAckCountField();
            }
        }

        protected boolean validatellcSapAdminDelayAckCountField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminDelayAckCountField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.llcSapAdminDelayAckCountFieldLabel.setForeground(Color.yellow);
            } else {
                this.llcSapAdminDelayAckCountFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createllcSapAdminDelayAckTimerField() {
            String string = LlcSapsPanel.this.getOverride("ibm.nways.llc.model.LlcSaps.Panel.LlcSapAdminDelayAckTimer.access", "read-write");
            this.llcSapAdminDelayAckTimerFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.llcSapAdminDelayAckTimerFieldLabel = new Label(LlcSapsPanel.getNLSString("llcSapAdminDelayAckTimerLabel"), 2);
            if (this.llcSapAdminDelayAckTimerFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.llcSapAdminDelayAckTimerFieldLabel, (Component)longNumericInput);
                LlcSapsPanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.llcSapAdminDelayAckTimerFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getllcSapAdminDelayAckTimerField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminDelayAckTimerField);
            this.validatellcSapAdminDelayAckTimerField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setllcSapAdminDelayAckTimerField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminDelayAckTimerField);
                jDMInput.setValue(object);
                this.validatellcSapAdminDelayAckTimerField();
            }
        }

        protected boolean validatellcSapAdminDelayAckTimerField() {
            JDMInput jDMInput = (JDMInput)((Object)this.llcSapAdminDelayAckTimerField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.llcSapAdminDelayAckTimerFieldLabel.setForeground(Color.yellow);
            } else {
                this.llcSapAdminDelayAckTimerFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.ifIndexField = this.createifIndexField();
            this.ifDescrField = this.createifDescrField();
            this.llcSapNumberField = this.createllcSapNumberField();
            this.llcSapAdminMaxIPDUOctetsSendField = this.createllcSapAdminMaxIPDUOctetsSendField();
            this.llcSapAdminMaxUnackedIPDUsSendField = this.createllcSapAdminMaxUnackedIPDUsSendField();
            this.llcSapAdminMaxUnackedIPDUsRcvField = this.createllcSapAdminMaxUnackedIPDUsRcvField();
            this.llcSapAdminMaxRetransmitsField = this.createllcSapAdminMaxRetransmitsField();
            this.llcSapAdminAckTimerField = this.createllcSapAdminAckTimerField();
            this.llcSapAdminInactTimerField = this.createllcSapAdminInactTimerField();
            this.llcSapAdminDelayAckCountField = this.createllcSapAdminDelayAckCountField();
            this.llcSapAdminDelayAckTimerField = this.createllcSapAdminDelayAckTimerField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.ifIndexField)).ignoreValue() && this.ifIndexFieldWritable) {
                    LlcSapsPanel.this.IndexInfo.add("Index.IfIndex", this.getifIndexField());
                }
                if (!((JDMInput)((Object)this.ifDescrField)).ignoreValue() && this.ifDescrFieldWritable) {
                    LlcSapsPanel.this.PanelInfo.add("Panel.IfDescr", this.getifDescrField());
                }
                if (!((JDMInput)((Object)this.llcSapNumberField)).ignoreValue() && this.llcSapNumberFieldWritable) {
                    LlcSapsPanel.this.IndexInfo.add("Index.LlcSapNumber", this.getllcSapNumberField());
                }
                if (!((JDMInput)((Object)this.llcSapAdminMaxIPDUOctetsSendField)).ignoreValue() && this.llcSapAdminMaxIPDUOctetsSendFieldWritable) {
                    LlcSapsPanel.this.PanelInfo.add("Panel.LlcSapAdminMaxIPDUOctetsSend", this.getllcSapAdminMaxIPDUOctetsSendField());
                }
                if (!((JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsSendField)).ignoreValue() && this.llcSapAdminMaxUnackedIPDUsSendFieldWritable) {
                    LlcSapsPanel.this.PanelInfo.add("Panel.LlcSapAdminMaxUnackedIPDUsSend", this.getllcSapAdminMaxUnackedIPDUsSendField());
                }
                if (!((JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsRcvField)).ignoreValue() && this.llcSapAdminMaxUnackedIPDUsRcvFieldWritable) {
                    LlcSapsPanel.this.PanelInfo.add("Panel.LlcSapAdminMaxUnackedIPDUsRcv", this.getllcSapAdminMaxUnackedIPDUsRcvField());
                }
                if (!((JDMInput)((Object)this.llcSapAdminMaxRetransmitsField)).ignoreValue() && this.llcSapAdminMaxRetransmitsFieldWritable) {
                    LlcSapsPanel.this.PanelInfo.add("Panel.LlcSapAdminMaxRetransmits", this.getllcSapAdminMaxRetransmitsField());
                }
                if (!((JDMInput)((Object)this.llcSapAdminAckTimerField)).ignoreValue() && this.llcSapAdminAckTimerFieldWritable) {
                    LlcSapsPanel.this.PanelInfo.add("Panel.LlcSapAdminAckTimer", this.getllcSapAdminAckTimerField());
                }
                if (!((JDMInput)((Object)this.llcSapAdminInactTimerField)).ignoreValue() && this.llcSapAdminInactTimerFieldWritable) {
                    LlcSapsPanel.this.PanelInfo.add("Panel.LlcSapAdminInactTimer", this.getllcSapAdminInactTimerField());
                }
                if (!((JDMInput)((Object)this.llcSapAdminDelayAckCountField)).ignoreValue() && this.llcSapAdminDelayAckCountFieldWritable) {
                    LlcSapsPanel.this.PanelInfo.add("Panel.LlcSapAdminDelayAckCount", this.getllcSapAdminDelayAckCountField());
                }
                if (!((JDMInput)((Object)this.llcSapAdminDelayAckTimerField)).ignoreValue() && this.llcSapAdminDelayAckTimerFieldWritable) {
                    LlcSapsPanel.this.PanelInfo.add("Panel.LlcSapAdminDelayAckTimer", this.getllcSapAdminDelayAckTimerField());
                    return;
                }
            } else {
                LlcSapsPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("accessDataMsg"));
            try {
                this.setifIndexField(LlcSapsPanel.this.LlcSapsData.getValueAt("Index.IfIndex", LlcSapsPanel.this.LlcSapsIndex));
                this.setifDescrField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.IfDescr", LlcSapsPanel.this.LlcSapsIndex));
                this.setllcSapNumberField(LlcSapsPanel.this.LlcSapsData.getValueAt("Index.LlcSapNumber", LlcSapsPanel.this.LlcSapsIndex));
                this.setllcSapAdminMaxIPDUOctetsSendField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminMaxIPDUOctetsSend", LlcSapsPanel.this.LlcSapsIndex));
                this.setllcSapAdminMaxUnackedIPDUsSendField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminMaxUnackedIPDUsSend", LlcSapsPanel.this.LlcSapsIndex));
                this.setllcSapAdminMaxUnackedIPDUsRcvField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminMaxUnackedIPDUsRcv", LlcSapsPanel.this.LlcSapsIndex));
                this.setllcSapAdminMaxRetransmitsField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminMaxRetransmits", LlcSapsPanel.this.LlcSapsIndex));
                this.setllcSapAdminAckTimerField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminAckTimer", LlcSapsPanel.this.LlcSapsIndex));
                this.setllcSapAdminInactTimerField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminInactTimer", LlcSapsPanel.this.LlcSapsIndex));
                this.setllcSapAdminDelayAckCountField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminDelayAckCount", LlcSapsPanel.this.LlcSapsIndex));
                this.setllcSapAdminDelayAckTimerField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminDelayAckTimer", LlcSapsPanel.this.LlcSapsIndex));
            }
            catch (NullPointerException nullPointerException) {}
            LlcSapsPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setifIndexField(LlcSapsPanel.this.LlcSapsData.getValueAt("Index.IfIndex", LlcSapsPanel.this.LlcSapsIndex));
            this.setifDescrField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.IfDescr", LlcSapsPanel.this.LlcSapsIndex));
            this.setllcSapNumberField(LlcSapsPanel.this.LlcSapsData.getValueAt("Index.LlcSapNumber", LlcSapsPanel.this.LlcSapsIndex));
            this.setllcSapAdminMaxIPDUOctetsSendField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminMaxIPDUOctetsSend", LlcSapsPanel.this.LlcSapsIndex));
            this.setllcSapAdminMaxUnackedIPDUsSendField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminMaxUnackedIPDUsSend", LlcSapsPanel.this.LlcSapsIndex));
            this.setllcSapAdminMaxUnackedIPDUsRcvField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminMaxUnackedIPDUsRcv", LlcSapsPanel.this.LlcSapsIndex));
            this.setllcSapAdminMaxRetransmitsField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminMaxRetransmits", LlcSapsPanel.this.LlcSapsIndex));
            this.setllcSapAdminAckTimerField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminAckTimer", LlcSapsPanel.this.LlcSapsIndex));
            this.setllcSapAdminInactTimerField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminInactTimer", LlcSapsPanel.this.LlcSapsIndex));
            this.setllcSapAdminDelayAckCountField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminDelayAckCount", LlcSapsPanel.this.LlcSapsIndex));
            this.setllcSapAdminDelayAckTimerField(LlcSapsPanel.this.LlcSapsData.getValueAt("Panel.LlcSapAdminDelayAckTimer", LlcSapsPanel.this.LlcSapsIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsSendField)).ignoreValue() && !this.validatellcSapAdminMaxUnackedIPDUsSendField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.llcSapAdminMaxUnackedIPDUsRcvField)).ignoreValue() && !this.validatellcSapAdminMaxUnackedIPDUsRcvField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.llcSapAdminInactTimerField)).ignoreValue() && !this.validatellcSapAdminInactTimerField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.llcSapAdminDelayAckCountField)).ignoreValue() && !this.validatellcSapAdminDelayAckCountField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.llcSapAdminDelayAckTimerField)).ignoreValue() && !this.validatellcSapAdminDelayAckTimerField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.llcSapAdminMaxIPDUOctetsSendField)).ignoreValue() && !this.validatellcSapAdminMaxIPDUOctetsSendField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.llcSapAdminMaxRetransmitsField)).ignoreValue() && !this.validatellcSapAdminMaxRetransmitsField()) {
                return false;
            }
            return ((JDMInput)((Object)this.llcSapAdminAckTimerField)).ignoreValue() || this.validatellcSapAdminAckTimerField();
        }
    }

    public class LlcSaps
    extends Table {
        public ModelInfo setRow() {
            try {
                LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("startSendMsg"));
                LlcSapsPanel.this.PanelInfo = LlcSapsPanel.this.LlcSaps_model.setInfo("Panel", LlcSapsPanel.this.PanelInfo);
                LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("endSendMsg"));
                if (LlcSapsPanel.this.PanelInfo != null) {
                    Enumeration enumeration = LlcSapsPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = LlcSapsPanel.this.PanelInfo.get(string);
                        LlcSapsPanel.this.LlcSapsInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LlcSapsPanel.this.LlcSapsInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    LlcSapsPanel.this.LlcSapsInfo = null;
                    LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("startRow"));
                    LlcSapsPanel.this.PanelInfo = LlcSapsPanel.this.LlcSaps_model.getNextInfo("Panel", "default", modelInfo);
                    LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("endRow"));
                    if (LlcSapsPanel.this.PanelInfo != null) {
                        LlcSapsPanel.this.LlcSapsInfo = new ModelInfo();
                        if (LlcSapsPanel.this.PanelInfo.isBeingMonitored()) {
                            LlcSapsPanel.this.LlcSapsInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = LlcSapsPanel.this.PanelInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = LlcSapsPanel.this.PanelInfo.get(string);
                            LlcSapsPanel.this.LlcSapsInfo.add(string, serializable);
                        }
                    }
                    if (LlcSapsPanel.this.LlcSapsInfo != null && !this.validRow(LlcSapsPanel.this.LlcSapsInfo)) {
                        modelInfo = LlcSapsPanel.this.LlcSapsInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LlcSapsPanel.this.LlcSapsInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            LlcSapsPanel.this.LlcSapsInfo = null;
            try {
                LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("startRow"));
                LlcSapsPanel.this.PanelInfo = LlcSapsPanel.this.LlcSaps_model.getInfo("Panel", "default", modelInfo);
                LlcSapsPanel.this.displayMsg(LlcSapsPanel.getNLSString("endRow"));
                if (LlcSapsPanel.this.PanelInfo != null) {
                    LlcSapsPanel.this.LlcSapsInfo = new ModelInfo();
                    if (LlcSapsPanel.this.PanelInfo.isBeingMonitored()) {
                        LlcSapsPanel.this.LlcSapsInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = LlcSapsPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = LlcSapsPanel.this.PanelInfo.get(string);
                        LlcSapsPanel.this.LlcSapsInfo.add(string, serializable);
                    }
                }
                if (LlcSapsPanel.this.LlcSapsInfo != null && !this.validRow(LlcSapsPanel.this.LlcSapsInfo)) {
                    LlcSapsPanel.this.LlcSapsInfo = this.getRow(LlcSapsPanel.this.LlcSapsInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LlcSapsPanel.this.LlcSapsInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (LlcSapsPanel.this.LlcSapsStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            LlcSapsPanel.this.LlcSapsStatus.monitor(modelInfoArray);
                            return;
                        }
                        LlcSapsPanel.this.LlcSapsStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        LlcSapsPanel.this.LlcSapsStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    LlcSapsPanel.this.LlcSapsStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            return string2;
        }

        public LlcSaps() {
            LlcSapsPanel.this = LlcSapsPanel.this;
        }
    }
}

